package ru.yandex.ambry.dto;

import java.io.IOException;
import java.time.Instant;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LastUpdatedResponse extends AbstractResponse {
    public Response response;

    public static class Response {
        public Integer total;

        @JsonProperty("last_updated")
        @JsonDeserialize(using = PythonInstantDeserializer.class)
        public Instant lastUpdated;
    }

    public static class PythonInstantDeserializer extends JsonDeserializer<Instant> {

        @Override
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String node = p.readValueAs(String.class);
            return Instant.parse(node + "Z");
        }
    }
}
