package ru.yandex.ambry.dto;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Ivan Tsybulin
 * @see <a href="https://wiki.yandex-team.ru/golovan/userdocs/alerts/api/#alert">Wiki</a>
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class YasmAlertDto {
    public String name;
    public String description;

    public String updated;
    public String abc;

    public String signal;
    @JsonDeserialize(using = TagsField.Deserializer.class)
    public Map<String, List<String>> tags;
    public List<String> mgroups;

    public List<Double> crit;
    public List<Double> warn;
    public Boolean disaster;

    @JsonProperty("warn_perc")
    public Double warnPerc;
    @JsonProperty("crit_perc")
    public Double critPerc;

    public String trend;
    public Integer interval;
    @JsonProperty("interval_modify")
    public IntervalModify intervalModify;
    @JsonProperty("value_modify")
    public ValueModify valueModify;

    @JsonProperty("juggler_check")
    public JugglerCheck jugglerCheck;

    public static class IntervalModify {
        public String type;
        public Integer quant;
        @JsonProperty("interval_end_offset")
        public Integer intervalEndOffset;
    }

    public static class ValueModify {
        public String type;
        public Integer window;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class JugglerCheck {
        public String host;
        public String service;
        public String namespace;

        // TODO
    }
}
