package ru.yandex.blackbox;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class BlackboxClientOptions {
    private final String url;
    private final String host;
    private final MetricRegistry registry;

    private BlackboxClientOptions(Builder builder) {
        this.url = Objects.requireNonNull(builder.url);
        this.host = Objects.requireNonNull(builder.host);
        this.registry = builder.metricRegistry != null
                ? builder.metricRegistry
                : MetricRegistry.root();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUrl() {
        return url;
    }

    public String getHost() {
        return host;
    }

    public MetricRegistry getRegistry() {
        return registry;
    }

    public static class Builder {
        @Nullable
        private String url;
        @Nullable
        private String host;
        @Nullable
        private MetricRegistry metricRegistry;

        private Builder() {
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setMetricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public BlackboxClientOptions build() {
            return new BlackboxClientOptions(this);
        }
    }
}
