package ru.yandex.blackbox;

import javax.annotation.WillNotClose;

import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.blackbox.cache.CachingBlackboxClient;
import ru.yandex.blackbox.fake.FakeBlackboxClient;
import ru.yandex.blackbox.http.HttpBlackboxClient;

/**
 * @author Vladimir Gordiychuk
 */
public final class BlackboxClients {
    private BlackboxClients() {}

    public static BlackboxClient create(@WillNotClose AsyncHttpClient client, BlackboxClientOptions opts) {
        return new HttpBlackboxClient(client, opts);
    }

    public static BlackboxClient caching(BlackboxClient delegate) {
        return new CachingBlackboxClient(delegate);
    }

    public static BlackboxClient fake() {
        return FakeBlackboxClient.INSTANCE;
    }
}
