package ru.yandex.blackbox.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.UserInfo;

/**
 * @author Sergey Polovko
 */
public class CachingBlackboxClient implements BlackboxClient {

    private Cache<String, UserInfo> login2UserInfoCache = CacheBuilder.newBuilder()
            .expireAfterAccess(1, TimeUnit.HOURS)
            .build();
    private Cache<Long, UserInfo> uid2UserInfoCache = CacheBuilder.newBuilder()
            .expireAfterAccess(1, TimeUnit.HOURS)
            .build();

    private final BlackboxClient delegate;

    public CachingBlackboxClient(BlackboxClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<UserInfo> userInfo(String login, String userIp) {
        UserInfo user = login2UserInfoCache.getIfPresent(login);
        if (user != null) {
            return CompletableFuture.completedFuture(user);
        }

        return delegate.userInfo(login, userIp)
                .whenComplete((result, throwable) -> {
                    if (result != null) {
                        login2UserInfoCache.put(login, result);
                    }
                });
    }

    @Override
    public CompletableFuture<UserInfo> userInfo(long uid, String userIp) {
        UserInfo user = uid2UserInfoCache.getIfPresent(uid);
        if (user != null) {
            return CompletableFuture.completedFuture(user);
        }

        return delegate.userInfo(uid, userIp)
                .whenComplete((result, throwable) -> {
                    if (result != null) {
                        uid2UserInfoCache.put(uid, result);
                    }
                });
    }

    @Override
    public CompletableFuture<UserInfo> sessionId(String sessionId, String sslSessionId, String userIp) {
        // TODO: implement
        return delegate.sessionId(sessionId, sslSessionId, userIp);
    }

    @Override
    public CompletableFuture<UserInfo> oauth(String token, String[] scopes, String userIp) {
        // TODO: implement
        return delegate.oauth(token, scopes, userIp);
    }
}
