package ru.yandex.blackbox.fake;

import java.util.concurrent.CompletableFuture;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.UserInfo;

import static java.util.concurrent.CompletableFuture.failedFuture;

/**
 * @author Sergey Polovko
 */
public class FakeBlackboxClient implements BlackboxClient {

    public static final FakeBlackboxClient INSTANCE = new FakeBlackboxClient();

    private FakeBlackboxClient() {
    }

    @Override
    public CompletableFuture<UserInfo> userInfo(String login, String userIp) {
        return failedFuture(new UnsupportedOperationException("this is a fake blackbox client"));
    }

    @Override
    public CompletableFuture<UserInfo> userInfo(long uid, String userIp) {
        return failedFuture(new UnsupportedOperationException("this is a fake blackbox client"));
    }

    @Override
    public CompletableFuture<UserInfo> sessionId(String sessionId, String sslSessionId, String userIp) {
        return failedFuture(new UnsupportedOperationException("this is a fake blackbox client"));
    }

    @Override
    public CompletableFuture<UserInfo> oauth(String token, String[] scopes, String userIp) {
        return failedFuture(new UnsupportedOperationException("this is a fake blackbox client"));
    }
}
