package ru.yandex.blackbox.http;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Polovko
 */
interface Dto {

    @JsonIgnoreProperties(ignoreUnknown = true)
    class UserInfoResponse {
        UserInfo[] users = {};
        @JsonProperty
        String error = "";

        @JsonProperty("users")
        public void setUsers(List<UserInfo> users) {
            this.users = users.stream()
                    .filter(user -> user.id != 0L)
                    .toArray(UserInfo[]::new);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class SessionIdResponse {
        @JsonProperty
        Status status;
        @JsonProperty
        long id;
        @JsonProperty
        String login;
        @JsonProperty
        String error = "";
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class OauthResponse {
        @JsonProperty
        Status status;
        @JsonProperty
        Uid uid;
        @JsonProperty
        String login;
        @JsonProperty
        String error = "";
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class UserInfo {
        @JsonProperty
        long id;
        @JsonProperty
        String login;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Status {
        @JsonProperty
        String value;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Uid {
        @JsonProperty
        long value;
    }
}
