package ru.yandex.blackbox.http;

import java.io.IOException;
import java.io.UncheckedIOException;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Sergey Polovko
 */
final class ResponseParser {
    private ResponseParser() {}

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static Dto.UserInfoResponse parseUserInfo(String response) {
        return parseJson(response, Dto.UserInfoResponse.class);
    }

    public static Dto.SessionIdResponse parseSessionId(String response) {
        return parseJson(response, Dto.SessionIdResponse.class);
    }

    public static Dto.OauthResponse parseOauth(String response) {
        return parseJson(response, Dto.OauthResponse.class);
    }

    private static <T> T parseJson(String response, Class<T> clazz) {
        try {
            return MAPPER.readValue(response, clazz);
        } catch (IOException e) {
            throw new UncheckedIOException("cannot parse " + clazz.getSimpleName(), e);
        }
    }
}
