package ru.yandex.blackbox.http;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxClientOptions;
import ru.yandex.blackbox.BlackboxClients;

/**
 * @author Vladimir Gordiychuk
 */
public class HttpBlackboxClientTest {

    private AsyncHttpClient httpClient;
    private BlackboxClient blackboxClient;

    @Before
    public void setUp() throws Exception {
        httpClient = new DefaultAsyncHttpClient();

        BlackboxClientOptions opts = BlackboxClientOptions.newBuilder()
                .setUrl("http://blackbox.yandex-team.ru")
                .build();

        blackboxClient = BlackboxClients.create(httpClient, opts);
    }

    @After
    public void tearDown() throws Exception {
        httpClient.close();
    }

    @Ignore
    public void resolveUserInfo() {
        blackboxClient.userInfo("gordiychuk", "").join();
    }
}
