package ru.yandex.blackbox.http;

import java.io.IOException;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import org.junit.Test;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class ResponseParserTest {

    @Test
    public void parseSuccess() throws IOException {
        var response = ResponseParser.parseUserInfo(load("userInfoSuccessResponse.json"));
        assertThat(response.users, arrayWithSize(1));
        assertThat(response.users[0].login, equalTo("gordiychuk"));
        assertThat(response.users[0].id, equalTo(1120000000047567L));
        assertThat(response.error, isEmptyOrNullString());
    }

    @Test
    public void parseError() throws IOException {
        var response = ResponseParser.parseUserInfo(load("userInfoErrorResponse.json"));
        assertThat(response.users, arrayWithSize(0));
        assertThat(response.error, equalTo("BlackBox error: Illegal dbfield: usersasd"));
    }

    @Test
    public void parseNotFound() throws IOException {
        var response = ResponseParser.parseUserInfo(load("userInfoNotFoundResponse.json"));
        assertThat(response.users, arrayWithSize(0));
        assertThat(response.error, isEmptyOrNullString());
    }

    private static String load(String res) throws IOException {
        return Resources.toString(ResponseParserTest.class.getResource(res), Charsets.UTF_8);
    }
}
