package ru.yandex.cloud.auth.token;

import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.cloud.token.Jwt;


/**
 * @author Sergey Polovko
 */
public interface TokenProvider {

    String getToken();

    static TokenProvider of(String token) {
        return new StaticTokenProvider(token);
    }

    /**
     * Create IAM-token provider, which will generate token by service account key and will refresh it
     * in background.
     *
     * @param tokenClient  client of IAM token service
     * @param jwtBuilder   prepared JSON Web token builder
     * @param scheduler    scheduler for background tasks
     * @return new instance of IAM-token provider
     */
    static TokenProvider iam(IamTokenClient tokenClient, Jwt.Builder jwtBuilder, ScheduledExecutorService scheduler) {
        return new IamTokenProvider(tokenClient, jwtBuilder, scheduler);
    }
}
