package ru.yandex.cloud.auth.token;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.cloud.token.IamToken;
import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.cloud.token.Jwt;

import static java.util.concurrent.CompletableFuture.completedFuture;


/**
 * @author Sergey Polovko
 */
public class IamTokenProviderTest {

    private static final String KEY =
        "-----BEGIN PRIVATE KEY-----\n" +
        "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC4Yp3ghrf721O3\n" +
        "OvWDOJMX/cdVMMxBRkQHTuGV/Wp5UnuKbsWKYPh6ALvOgRK2jNL3kVJ9DkP1BDaQ\n" +
        "/I18ue9cqlJeAPwlSKWu/BrIc/9FItBsIMUIttJ6t2avhr/NRg12b2arMvZHtJuN\n" +
        "a5HpZiQkt5Pr9Vi5W87Cn2Y9pHCjvGEeTkTAIzaVtZMEffbxhWP/kJcJN4xUC047\n" +
        "4dzTc7Mrs5lklO13u7nF3Fh6VheqP1jCd/qi2DQxvyU59teNP4Lk3pr4/MhUnLhk\n" +
        "AFDClnW1roegkEL1eKRG95lCQlyQ+lt3+YbGCBNWByXPQ4uUAZu5l8c1aDos7VrS\n" +
        "byWjsjWlAgMBAAECggEABkS0AVITJyjJq80BU7i0p3glMqw6BW4SGf2Ahczbtcws\n" +
        "DwS9CntJdzxXJioVLMeU1H3IRCAcB1RhVoR/euIHVSslKbT23X2exFglwPLQltUc\n" +
        "KNDkYet1NF7Pyt/V3XCoPIKFBwTwgneNYj1p9HlYeTcUfE0W+xY37T3mB+pzOd26\n" +
        "2b44hZjYZsw0JtrlMExfEodOgWlgu5vfMy7NO9k1x76PdTVaKDWn3dPMy5+2LuQf\n" +
        "QD9g2bgd/+vOprwDYhaeENrqG7TBps6DquXwGPSNWr+LAcFL7mO0AQB8Ve9bBbfY\n" +
        "en0Vti9+q1vKGfSPsXnnaqHCiduCrQzcYWhy2mj58QKBgQDaYkyZCF/OwD00cgq9\n" +
        "zS8IpWBbSulSRgaXkLCGlxmzU2RQBRYKgbuELavFYNB+tYbFtZ/IL4tdiEDxCsqU\n" +
        "0Ul3rfdTg8uxJ88rhp4naTDxYYUOQZV36trgOiVnOY8sUeGx3qAa9rbU7KxN8jsT\n" +
        "K1qSRZRmqPFrZq/qYuhX+yI1lwKBgQDYJSIK4ILUzSC0oFkFTJpzYM8jTUGSL4AG\n" +
        "SfxvNaLjswrlqlF1ZT8qn5TtP5xevyRV4VbsATT4qx+wcfgU/eoTjEb+/6nPht3P\n" +
        "zggxv9BW6ILlOqLQl8HMs5n4TiLDMluDLwA8GEGE3OSOlfKt8s9hLRlNv7RVX80h\n" +
        "lR5xaLJuIwKBgBZ50Xpak0m7HVF9fz+Dk5inNKCQuCzAikMlIBXqDToYlhVqQJd6\n" +
        "PKtg6/HXgf3YfvNwOu6mfgh1UoG8Y5cnZxFLNU5CHT+xYjAPnc1elSvypngOJez+\n" +
        "neI/+cOC+ApOrxTYXdAInk6RwTYQfSX+60ZspNZgAuDT470SyujrLt0nAoGAT0df\n" +
        "cyniEveiNV5TCJSOWh96GnKtyFbP2H6uroO32VjEeHS+KBcY0iNyVorsafwl8bIT\n" +
        "VcEjksoBd5B19A0mHEFpkQJpYIsRNLVXYBgA7L+fs0CMk4H2PYTqxp6yNXJ1Cmrk\n" +
        "5SXocjkrQ/lP5+mVkwkdrNzR4jafYN/3KJXETI0CgYEAq9PmktArSct+wH6eC2wp\n" +
        "dxm8WzKbnSexJTNnbZcwzT1tqTiQWhyTx8YdP8yclUOtSb/24b8WMiqpm90Dry8y\n" +
        "IbqaWr0XHhdcbd93FVEOMY31z4GVqfe7i0DiATewNHPr51RMhQ5KOlorIZBEzRdm\n" +
        "uHPeiadN9nL+fS2CYwHtnzo=\n" +
        "-----END PRIVATE KEY-----\n";

    private ScheduledExecutorService scheduler;

    @Before
    public void setUp() {
        scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    @After
    public void tearDown() throws Exception {
        scheduler.shutdown();
        scheduler.awaitTermination(10, TimeUnit.SECONDS);
    }

    @Test
    public void getToken() {
        var fakeTokenClient = (IamTokenClient) jwt -> {
            Instant expiresAt = Instant.now().plus(10, ChronoUnit.MINUTES);
            return completedFuture(new IamToken("my-iam-token", expiresAt));
        };

        var jwtBuilder = Jwt.newBuilder()
                .withAccountId("my-account")
                .withKeyId("my-key")
                .withPrivateKey(KEY);

        var tokenProvider = new IamTokenProvider(fakeTokenClient, jwtBuilder, scheduler);
        String token = tokenProvider.getToken();
        Assert.assertEquals("my-iam-token", token);
    }
}
