package ru.yandex.cloud.client.compute;

import javax.annotation.concurrent.Immutable;

import static java.util.Objects.requireNonNull;


/**
 * @author Sergey Polovko
 */
@Immutable
public class Resource {

    private final String cloudId;
    private final String folderId;
    private final String resourceId;
    private final String name;
    private final String type;

    public Resource(String cloudId, String folderId, String resourceId, String name, String type) {
        this.cloudId = requireNonNull(cloudId, "cloudId");
        this.folderId = requireNonNull(folderId, "folderId");
        this.resourceId = requireNonNull(resourceId, "resourceId");
        this.name = requireNonNull(name, "name");
        this.type = requireNonNull(type, "type");
    }

    public String getCloudId() {
        return cloudId;
    }

    public String getFolderId() {
        return folderId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Resource resource = (Resource) o;
        if (!cloudId.equals(resource.cloudId)) return false;
        if (!folderId.equals(resource.folderId)) return false;
        if (!resourceId.equals(resource.resourceId)) return false;
        if (!type.equals(resource.type)) return false;
        return name.equals(resource.name);
    }

    @Override
    public int hashCode() {
        int result = cloudId.hashCode();
        result = 31 * result + folderId.hashCode();
        result = 31 * result + resourceId.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Resource{" +
            "cloudId='" + cloudId + '\'' +
            ", folderId='" + folderId + '\'' +
            ", resourceId='" + resourceId + '\'' +
            ", name='" + name + '\'' +
            ", type='" + type + '\'' +
            '}';
    }
}
