package ru.yandex.cloud.client.compute.http;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author Sergey Polovko
 */
interface Dto {

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Types {
        @JsonProperty
        Set<String> types;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Resource {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty("cloud_id")
        String cloudId;
        @JsonProperty("folder_id")
        String folderId;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class ResourcesPage {
        @JsonProperty("page_token")
        String pageToken;
        @JsonProperty
        List<Resource> resources;
    }

}
