package ru.yandex.cloud.client.identity;

import javax.annotation.concurrent.Immutable;

import static java.util.Objects.requireNonNull;


/**
 * @author Sergey Polovko
 */
@Immutable
public class Cloud {

    private final String id;
    private final String name;

    public Cloud(String id, String name) {
        this.id = requireNonNull(id, "id");
        this.name = requireNonNull(name, "name");
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Cloud cloud = (Cloud) o;
        if (!id.equals(cloud.id)) return false;
        return name.equals(cloud.name);
    }

    @Override
    public int hashCode() {
        int result = id.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Cloud{id='" + id + "', name='" + name + "'}";
    }
}
