package ru.yandex.cloud.client.identity;

import javax.annotation.concurrent.Immutable;

import static java.util.Objects.requireNonNull;


/**
 * @author Sergey Polovko
 */
@Immutable
public class Folder {

    private final String cloudId;
    private final String folderId;
    private final String name;

    public Folder(String cloudId, String folderId, String name) {
        this.cloudId = requireNonNull(cloudId, "cloudId");
        this.folderId = requireNonNull(folderId, "folderId");
        this.name = requireNonNull(name, "name");
    }

    public String getCloudId() {
        return cloudId;
    }

    public String getFolderId() {
        return folderId;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Folder folder = (Folder) o;
        if (!cloudId.equals(folder.cloudId)) return false;
        if (!folderId.equals(folder.folderId)) return false;
        return name.equals(folder.name);
    }

    @Override
    public int hashCode() {
        int result = cloudId.hashCode();
        result = 31 * result + folderId.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Folder{cloudId='" + cloudId + "', folderId='" + folderId + "', name='" + name + "'}";
    }
}
