package ru.yandex.cloud.client.identity.http;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author Sergey Polovko
 */
interface Dto {

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Page<T> {
        @JsonProperty
        List<T> result;
        @JsonProperty
        String nextPageToken;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Folder {
        @JsonProperty
        String id;
        @JsonProperty
        String cloudId;
        @JsonProperty
        String name;
    }

    class FoldersPage extends Page<Folder> {
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Cloud {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty
        String status;
    }

    class CloudsPage extends Page<Cloud> {
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class User {
        @JsonProperty
        String id;
        @JsonProperty
        String login;
        @JsonProperty
        String firstName;
        @JsonProperty
        String lastName;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    class Users {
        @JsonProperty
        List<User> users;
    }
}
