package ru.yandex.cloud.client.identity.http;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

import javax.annotation.Nullable;


/**
 * @author Sergey Polovko
 */
abstract class PagesFetcher<M, T, PageDto extends Dto.Page<T>> implements BiConsumer<PageDto, Throwable> {

    private final CompletableFuture<List<M>> future = new CompletableFuture<>();
    private final List<M> items = new ArrayList<>(1000);

    PagesFetcher() {
        readNextPage(null);
    }

    abstract CompletableFuture<PageDto> fetchPage(@Nullable String pageToken);

    abstract boolean filter(T dto);

    abstract M convertDto(T dto);

    private void readNextPage(@Nullable String pageToken) {
        fetchPage(pageToken).whenComplete(this);
    }

    /**
     * called on each async fetch completion
     */
    @Override
    public void accept(PageDto page, Throwable throwable) {
        if (throwable != null) {
            future.completeExceptionally(throwable);
            return;
        }
        for (T dto : page.result) {
            if (filter(dto)) {
                items.add(convertDto(dto));
            }
        }

        String nextPageToken = page.nextPageToken;
        if (nextPageToken != null && !nextPageToken.isEmpty()) {
            if (!future.isCancelled()) {
                readNextPage(nextPageToken);
            }
        } else {
            future.complete(items);
        }
    }

    CompletableFuture<List<M>> getFuture() {
        return future;
    }
}
