package ru.yandex.cloud.resourcemanager;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

/**
 * @author Oleg Baryshnikov
 */
@Immutable
@ParametersAreNonnullByDefault
public class ResolvedFolder {
    private final String id;
    private final String cloudId;

    public ResolvedFolder(String id, String cloudId) {
        this.id = id;
        this.cloudId = cloudId;
    }

    public String getId() {
        return id;
    }

    public String getCloudId() {
        return cloudId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ResolvedFolder that = (ResolvedFolder) o;

        if (!id.equals(that.id)) {
            return false;
        }
        return cloudId.equals(that.cloudId);
    }

    @Override
    public int hashCode() {
        int result = id.hashCode();
        result = 31 * result + cloudId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ResolvedFolder{" +
                "id='" + id + '\'' +
                ", cloudId='" + cloudId + '\'' +
                '}';
    }
}
