package ru.yandex.cloud.session;

import java.util.concurrent.CompletableFuture;

/**
 * @author Sergey Polovko
 */
public interface SessionClient {

    /**
     * Verify the identity of a subject for services, authenticated via Yandex.Cloud IdP.
     *
     * @param domain         service host address, for example "datalens.yandex.ru" or "tracker.yandex.com".
     * @param cookieHeader   HTTP-header Cookie with required per-service cookie values (e.g. yc_session).
     * @param federationId   if not empty - specified federation id should be used for authorization,
     *                       otherwise authorization IdP calculated from cookies.
     * @return session state, either {@link Session.Present} or {@link Session.Absent}.
     */
    CompletableFuture<? extends Session> check(String domain, String cookieHeader, String federationId);

    /**
     * Create per-service session.
     *
     * @param domain      which hosts are allowed to receive the cookie.
     * @param accessToken access token from successful token response, see
     *                    <a href="https://openid.net/specs/openid-connect-core-1_0.html#TokenResponse">TokenResponse</a>
     *                    for details.
     * @return session state, either {@link Session.Created} or {@link Session.Absent}.
     */
    CompletableFuture<? extends Session> create(String domain, String accessToken);
}
