package ru.yandex.cloud.session.grpc;

import java.time.Instant;

import com.google.protobuf.Timestamp;
import yandex.cloud.priv.iam.v1.PIT;

import ru.yandex.cloud.token.IamToken;

/**
 * @author Sergey Polovko
 */
final class Proto {
    private Proto() {}

    /**
     * Converts IAM-token from given protobuf message
     * <a href="https://bb.yandex-team.ru/projects/CLOUD/repos/cloud-go/browse/private-api/yandex/cloud/priv/iam/v1/token/iam_token.proto">IamToken</a>
     * to an {@link IamToken} object.
     *
     * @param token  protobuf message of IAM-token
     * @return {@link IamToken} object
     */
    static IamToken toIamToken(PIT.IamToken token) {
        return new IamToken(token.getIamToken(), toInstant(token.getExpiresAt()));
    }

    static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }
}
