package ru.yandex.cloud.token;

import java.time.Duration;
import java.util.concurrent.Executor;

import javax.annotation.WillNotClose;

import com.google.common.util.concurrent.MoreExecutors;

import static java.util.Objects.requireNonNull;

/**
 * @author Sergey Polovko
 */
public class IamOauthClientOptions {

    private final String endpoint;
    private String clientId;
    private String clientSecret;
    private Executor handlerExecutor = MoreExecutors.directExecutor();
    private Duration connectTimeout = Duration.ofSeconds(5);
    private Duration requestTimeout = Duration.ofSeconds(10);

    private IamOauthClientOptions(String endpoint) {
        this.endpoint = endpoint;
    }

    public static IamOauthClientOptions forEndpoint(String endpoint) {
        return new IamOauthClientOptions(endpoint);
    }

    public String getEndpoint() {
        return endpoint;
    }

    public String getClientId() {
        return clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public Executor getHandlerExecutor() {
        return handlerExecutor;
    }

    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    public IamOauthClientOptions withClientId(String clientId) {
        this.clientId = requireNonNull(clientId);
        return this;
    }

    public IamOauthClientOptions withClientSecret(String clientSecret) {
        this.clientSecret = requireNonNull(clientSecret);
        return this;
    }

    public IamOauthClientOptions withHandlerExecutor(@WillNotClose Executor executor) {
        this.handlerExecutor = requireNonNull(executor);
        return this;
    }

    public IamOauthClientOptions withConnectTimeout(Duration timeout) {
        this.connectTimeout = requireNonNull(timeout);
        return this;
    }

    public IamOauthClientOptions withRequestTimeout(Duration timeout) {
        this.requestTimeout = requireNonNull(timeout);
        return this;
    }
}
