package ru.yandex.cloud.token;

import java.time.Instant;

/**
 * @author Sergey Polovko
 */
public class IamToken {

    private final String value;
    private final Instant expiresAt;

    public IamToken(String value, Instant expiresAt) {
        this.value = value;
        this.expiresAt = expiresAt;
    }

    public String getValue() {
        return value;
    }

    public Instant getExpiresAt() {
        return expiresAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        IamToken iamToken = (IamToken) o;

        if (!value.equals(iamToken.value)) return false;
        return expiresAt.equals(iamToken.expiresAt);
    }

    @Override
    public int hashCode() {
        int result = value.hashCode();
        result = 31 * result + expiresAt.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "IamToken{value='" + value + '\'' + ", expiresAt=" + expiresAt + '}';
    }
}
