package ru.yandex.cloud.token;

import java.util.concurrent.CompletableFuture;

/**
 * @author Sergey Polovko
 */
public interface IamTokenClient {

    /**
     * Create IAM-token by signed <a href="https://tools.ietf.org/html/rfc7519">JSON Web Token</a>.
     *
     * @param jwt  signed JW-token
     * @return IAM-token
     */
    CompletableFuture<IamToken> createByJwt(String jwt);

}
