package ru.yandex.cloud.token;

import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;

import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

import static java.util.Objects.requireNonNull;

/**
 * @author Sergey Polovko
 */
final class Pem {
    private Pem() {}

    public static PrivateKey fromFile(Path path) {
        try {
            return readPem(Files.newBufferedReader(path));
        } catch (Exception e) {
            throw new RuntimeException("cannot read private key from " + path, e);
        }
    }

    public static PrivateKey fromString(String data) {
        try {
            return readPem(new StringReader(data));
        } catch (Exception e) {
            throw new RuntimeException("cannot read private from " + data, e);
        }
    }

    private static PrivateKey readPem(Reader in) throws Exception {
        try (PemReader reader = new PemReader(in)) {
            PemObject privateKeyPem = requireNonNull(reader.readPemObject(), "privateKeyPem");
            KeyFactory keyFactory = requireNonNull(KeyFactory.getInstance("RSA"), "keyFactory");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyPem.getContent()));
        }
    }
}
