package ru.yandex.cloud.token;

import java.time.Instant;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.cloud.token.grpc.GrpcIamTokenClient;
import ru.yandex.devtools.test.annotations.YaIgnore;

/**
 *
 * $ yc --profile preprod iam service-account get bfbmbpkthg5gal3vv90j
 * id: bfbmbpkthg5gal3vv90j
 * folder_id: aoeks4hjfdtntnr8sccp
 * created_at: "2019-01-21T16:36:52Z"
 * name: test-viewer
 *
 * $ yc --profile preprod iam key create --service-account-id bfbmbpkthg5gal3vv90j --output sa_key.json
 *
 * $ jq -r .id sa_key.json
 * $ jq -r .private_key sa_key.json
 *
 * @author Sergey Polovko
 */
@YaIgnore
public class IamTokenClientTest {

    static final String ACCOUNT_ID = "bfbmbpkthg5gal3vv90j";
    static final String KEY_ID = "bfbdb2fnioq1onclpbvo";

    static final String PUBLIC_KEY =
            "-----BEGIN PUBLIC KEY-----\n" +
            "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArpOT9UamFQl/UKtBJ+Xk\n" +
            "NosMHIJFnksPmT66YieOnKZ0Q1BaD2Yhb1ZWpmxisc7xH85DBQGDkULC67IaokN9\n" +
            "TkM9sYzC2NsMMSUzidedqSvvbNWRHgB8/AynhWkNlWj2cwzHM0vk/kmRPAqHJpOH\n" +
            "eYk+DFDbDINHGWlKtiIZ+5JnfqpYeEYjS9ad4GLG2gxYc8q9hkl+r3sKeEz7xFZO\n" +
            "HqT9lX4dqoB0jr0bYAXmKsSpxftnDad9tL2U5dNaZyBWNeMcWMWDbIAnNgq/BBER\n" +
            "Sp84JRIgoG3HW92sL++H7Rh2cf1hRZ/ipn0YTd1/lBxn1JnKK5nvJMl+N6itfZt7\n" +
            "OQIDAQAB\n" +
            "-----END PUBLIC KEY-----";

    static final String PRIVATE_KEY =
            "-----BEGIN PRIVATE KEY-----\n" +
            "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCuk5P1RqYVCX9Q\n" +
            "q0En5eQ2iwwcgkWeSw+ZPrpiJ46cpnRDUFoPZiFvVlambGKxzvEfzkMFAYORQsLr\n" +
            "shqiQ31OQz2xjMLY2wwxJTOJ152pK+9s1ZEeAHz8DKeFaQ2VaPZzDMczS+T+SZE8\n" +
            "Cocmk4d5iT4MUNsMg0cZaUq2Ihn7kmd+qlh4RiNL1p3gYsbaDFhzyr2GSX6vewp4\n" +
            "TPvEVk4epP2Vfh2qgHSOvRtgBeYqxKnF+2cNp320vZTl01pnIFY14xxYxYNsgCc2\n" +
            "Cr8EERFKnzglEiCgbcdb3awv74ftGHZx/WFFn+KmfRhN3X+UHGfUmcorme8kyX43\n" +
            "qK19m3s5AgMBAAECggEAIKhy8Vt6Dk1sh8bBtZkIDDwO0/Z615XrIRve+iW0RBHP\n" +
            "hhguANt2PcHFC/USsXipGu4XE4So/C+lDzqOSPSfKFjj3acbfD3eFgODlLHFSLRz\n" +
            "YcTCFP66YtxrKkXwyJaOJA+r5Ci6eeeBR94gUlMe8Nl/xgYKNFkKn/JWi6PtgGYf\n" +
            "Q+grf1QndJptQeMOMLd9ozLErH25N7qGjULiwQl7sFARtkO0AFgzWF//Hyf5wPqi\n" +
            "96s/wJzbROtm2pQXU/3ceVLhJpNsJ0f/7ZJ/bq2gB1uD/Rc3GOCrts+a0XnInCT4\n" +
            "6gfLD92YxoCogQTBRQI33SpWU9qHe41yw5+Ap9DzEQKBgQDv4QAQEla0m8hH8hos\n" +
            "WscJI0DTirRWIWJt9gYm8iUmqjM++BiQCMzT5w7w0OEt51vgGikkBKtmM0huIXgi\n" +
            "YDFqGT0w6QGcxZHo7p3SI3ITlQWBoEH1+S7mOSdM7R2WG71oIVGPQ9+fRCJMqxjx\n" +
            "tK9JZYkJUIlGi1aG/0VBiT6mOwKBgQC6TxTJtAmEY1eMDC21D/ts/i0J0hrYF2oV\n" +
            "NHx0BM1pZqr/4bCCmwP72c7rA+2on9yi3jks0hjTkFpC9OfVN4Try3oEoV3HMNMy\n" +
            "uEx/RRPzf7y5GGqDsAU8Wq/9hAocys7ML2n7G4vMBt3IAmBHLMej6uKTSiI2YQ0a\n" +
            "HFxQ/ZmpGwKBgFX1vi0ENVgBXzMQ+fodCagnnupvkRIwYnJfMHMyYMfLRBPzmfG7\n" +
            "hZMGAN+hKqBlgRH8rfN/TOCRzgnRKpi++dY4dyoYxYAleJUNNTcBhrant1JtWFXJ\n" +
            "1tmfb4rsiaaqCCTRk8WQIAmVw+jPg1/STOIzZXkWCCtkcTxtK6dBhFbTAoGAFynF\n" +
            "193+YOtI8yyAckZuZ/qh9tqcY8llcwV3g6UlNLmDARU6MMK9GA7YXve6EIDvmYAv\n" +
            "c5cbZxJHZpO0Txn7+KTvoqu9UQqM931aZWhdNqTm/cw/UegMfph30PkdmL7OPyyV\n" +
            "7JZcJx2jbT5+Ydr7ZzHIwa8x2bjvPBPSlm8xL4kCgYEA5oUVVdpSSxrDz1XkcjCC\n" +
            "tFM6zerp6C0fOWN0UBa67QzPOfQhO0i5Z0ADBKRjHGYf0sIP2uFEHXEM7/m4oUwb\n" +
            "gVSUwSwN0n7poz2OPvyAL1MUczblp6HOYnxtlfeNxWN4HikcU20UDSdPVJbUWuWv\n" +
            "1T+gw8gi/29hDWJmoAP9ICY=\n" +
            "-----END PRIVATE KEY-----";

    @Test
    public void createByJwt() {
        String jwt = Jwt.newBuilder()
                .withAccountId(ACCOUNT_ID)
                .withKeyId(KEY_ID)
                .withPrivateKey(PRIVATE_KEY)
                .build();

        System.out.println("jwt: " + jwt);

        var client = new GrpcIamTokenClient(IamTokenClientOptions.forPreprod());
        IamToken token = client.createByJwt(jwt).join();

        System.out.println("iam: " + token);

        Assert.assertFalse(token.getValue().isEmpty());
        Assert.assertTrue(token.getExpiresAt().isAfter(Instant.now()));
    }
}
