package ru.yandex.idm.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErrorResponse extends DefaultObject {
    @JsonProperty("errors")
    public Errors errors;

    @JsonProperty("message")
    public String message;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public class Errors extends DefaultObject {
        @JsonProperty("user")
        public List<String> user;
        @JsonProperty("group")
        public List<String> group;
    }

    public String getMessage() {
        if (errors == null) {
            return Nullables.orEmpty(message);
        }
        return String.join("; ", Nullables.orEmpty(errors.user)) + String.join("; ", Nullables.orEmpty(errors.group));
    }
}
