package ru.yandex.idm.dto;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
public class RoleRequestDto extends DefaultObject {

    @JsonProperty("user")
    public String user;

    @JsonProperty("group")
    public Integer group;

    @JsonProperty("system")
    public String system;

    @JsonProperty("path")
    public String path;

    @JsonIgnore
    public boolean tvm;

    @JsonProperty("fields_data")
    public Map<String, String> fields;

    public static RoleRequestDto newProjectRoleRequest(String user, String projectId, String role, String system, boolean isTvm) {
        RoleRequestDto request = new RoleRequestDto();
        request.user = user;
        request.tvm = isTvm;
        fillBase(projectId, role, system, request);
        return request;
    }

    public static RoleRequestDto newProjectRoleRequest(int group, String projectId, String role, String system) {
        RoleRequestDto request = new RoleRequestDto();
        request.group = group;
        fillBase(projectId, role, system, request);
        return request;
    }

    private static void fillBase(String projectId, String role, String system, RoleRequestDto request) {
        request.system = system;
        //original path /type/project/role/.../
        if (role != null) {
            request.path = String.format("/project/%s/", role);
        }
        request.fields = Map.of("project", projectId);
    }
}
