package ru.yandex.jns.client;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.jns.dto.GetEscalationRequest;
import ru.yandex.jns.dto.JnsEscalationPolicy;
import ru.yandex.jns.dto.JnsListEscalationPolicy;
import ru.yandex.jns.dto.JnsSendMessageRequest;
import ru.yandex.jns.dto.ListEscalationRequest;
import ru.yandex.jns.dto.StartEscalationRequest;
import ru.yandex.jns.dto.StopEscalationRequest;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface JnsClient extends AutoCloseable {
    CompletableFuture<Void> sendMessage(JnsSendMessageRequest request);

    CompletableFuture<JnsListEscalationPolicy> listEscalations(ListEscalationRequest request);

    CompletableFuture<Optional<JnsEscalationPolicy>> getEscalation(GetEscalationRequest request);

    CompletableFuture<Void> startEscalation(StartEscalationRequest request);

    CompletableFuture<Void> stopEscalation(StopEscalationRequest request);
}
