package ru.yandex.jns.client;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.jns.dto.GetEscalationRequest;
import ru.yandex.jns.dto.JnsEscalationPolicy;
import ru.yandex.jns.dto.JnsListEscalationPolicy;
import ru.yandex.jns.dto.JnsSendMessageRequest;
import ru.yandex.jns.dto.ListEscalationRequest;
import ru.yandex.jns.dto.StartEscalationRequest;
import ru.yandex.jns.dto.StopEscalationRequest;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class JnsClientStub implements JnsClient {

    private AtomicReference<JnsSendMessageRequest> lastRequest = new AtomicReference<>(null);
    private boolean fail;
    public JnsListEscalationPolicy escalations = JnsListEscalationPolicy.EMPTY;

    @Override
    public CompletableFuture<Void> sendMessage(JnsSendMessageRequest request) {
        if (fail) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        lastRequest.set(request);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<JnsListEscalationPolicy> listEscalations(ListEscalationRequest request) {
        if (fail) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        return CompletableFuture.completedFuture(escalations);
    }

    @Override
    public CompletableFuture<Optional<JnsEscalationPolicy>> getEscalation(GetEscalationRequest request) {
        if (fail) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Void> startEscalation(StartEscalationRequest request) {
        if (fail) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stopEscalation(StopEscalationRequest request) {
        if (fail) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        return CompletableFuture.completedFuture(null);
    }

    public JnsSendMessageRequest getLastRequest() {
        return lastRequest.get();
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }

    @Override
    public void close() throws Exception {

    }
}
