package ru.yandex.jns.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public record JnsListEscalationPolicy(@JsonProperty("error") String error, @JsonProperty("message") String message,
                                      @JsonProperty("policies") List<JnsEscalationPolicy> policies) {

    public static JnsListEscalationPolicy EMPTY = new JnsListEscalationPolicy("", "", List.of());
    @JsonCreator
    public JnsListEscalationPolicy {
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public record JnsEscalationPolicy(@JsonProperty("name") String name, @JsonProperty("title") String title) {
        @JsonCreator
        public JnsEscalationPolicy {
        }
    }

}
