package ru.yandex.jns.dto;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class JnsSendMessageRequest extends DefaultObject {
    @JsonProperty("project")
    public String projectWithTemplate = "solomon";
    @JsonProperty("template")
    public String template = "phoneCommon";
    @JsonProperty("request_id")
    public String idempotencyKey;
    @JsonProperty("abc_service")
    public String projectAbcService;
    @JsonProperty("target_project")
    public String targetJnsProject = "solomon";
    @JsonProperty("params")
    public Map<String,Object> params = new HashMap<>();
    @JsonProperty("recipient")
    public JnsSendRecipient recipient;
}
