package ru.yandex.jns.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class JnsSendRecipient extends DefaultObject {
    @JsonProperty("phone")
    public PhoneChannelOptions phone;

    public static InternalUser duty(String abcService, String dutySlug) {
        InternalUser user = new InternalUser();
        AbcDuty duty = new AbcDuty();
        duty.dutySlug = dutySlug;
        duty.abcService = abcService;
        user.duty =  duty;
        return user;
    }

    public static InternalUser login(String login) {
        InternalUser user = new InternalUser();
        user.login =  login;
        return user;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PhoneChannelOptions extends DefaultObject {
        @JsonProperty("internal")
        public List<InternalUser> internal;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class InternalUser extends DefaultObject {
        @JsonProperty("login")
        public String login;
        @JsonProperty("abc_duty")
        public AbcDuty duty;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AbcDuty extends DefaultObject {
        @JsonProperty("service")
        public String abcService;
        @JsonProperty("slug")
        public String dutySlug;
    }
}
