package ru.yandex.jns.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public record StopEscalationRequest(@JsonProperty("key") Key key, @JsonProperty("terminator") Terminator terminator) {
    @JsonCreator
    public StopEscalationRequest {
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public record Key(@JsonProperty("project") String project, @JsonProperty("request_id") String id) {
        @JsonCreator
        public Key {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public record Terminator(@JsonProperty("kind") String kind, @JsonProperty("reason") String reason,
                             @JsonProperty("login") String login) {
        @JsonCreator
        public Terminator {
        }
    }

}
