package ru.yandex.juggler.client;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.EventStatus;
import ru.yandex.juggler.dto.JugglerEvent;
import ru.yandex.juggler.resolver.ProxyResolveObserver;
import ru.yandex.monlib.metrics.MetricSupplier;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface JugglerClient extends AutoCloseable, MetricSupplier, ProxyResolveObserver {
    CompletableFuture<EventStatus> sendEvent(JugglerEvent event);

    @Override
    void close();
}
