package ru.yandex.juggler.client;

import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.target.TargetMetrics;
import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerClientMetrics implements MetricSupplier {
    private final ConcurrentHashMap<String, TargetMetrics> perTargetMetrics = new ConcurrentHashMap<>();
    private final int targetMetricsCount;

    public JugglerClientMetrics() {
        targetMetricsCount = new TargetMetrics("").estimateCount();
    }

    public TargetMetrics getMetricsForTarget(String targetName) {
        return perTargetMetrics.computeIfAbsent(targetName,
                ignore -> new TargetMetrics(targetName));
    }

    @Override
    public int estimateCount() {
        return perTargetMetrics.values().stream()
                .mapToInt(TargetMetrics::estimateCount)
                .sum();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        TargetMetrics total = new TargetMetrics(""); // not "total" for compatibility with old client
        for (TargetMetrics target : perTargetMetrics.values()) {
            target.append(tsMillis, commonLabels, consumer);
            total.combine(target);
        }
        total.append(tsMillis, commonLabels, consumer);
    }
}
