package ru.yandex.juggler.client;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.ProjectDeleteRequestDto;
import ru.yandex.juggler.dto.ProjectDto;
import ru.yandex.juggler.dto.ProjectFindRequestDto;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface JugglerControlPlaneClient extends AutoCloseable {
    CompletableFuture<Void> createProject(ProjectDto requestDto);

    CompletableFuture<Void> deleteProject(ProjectDeleteRequestDto requestDto);

    CompletableFuture<Void> deleteProject(ProjectDto requestDto);

    CompletableFuture<Optional<ProjectDto>> getProject(ProjectFindRequestDto requestDto);

    CompletableFuture<Void> updateProject(ProjectDto requestDto);
}
