package ru.yandex.juggler.client;

import java.time.Duration;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.relay.CircuitBreakerFactory;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.failsafe.ExpMovingAverageCircuitBreaker;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerDirectClientOptions {
    Executor relayHttpExecutor;
    MetricRegistry registry = MetricRegistry.root();
    Duration relayConnectTimeout = Duration.ofSeconds(5);
    Duration relayResponseTimeout = Duration.ofSeconds(15);
    CircuitBreakerFactory relayCircuitBreakerFactory =
            () -> new ExpMovingAverageCircuitBreaker(0.4, Duration.ofSeconds(15).toMillis());

    public JugglerDirectClientOptions() {
    }

    public JugglerDirectClientOptions setRegistry(MetricRegistry registry) {
        this.registry = registry;
        return this;
    }

    public JugglerDirectClientOptions setRelayHttpExecutor(Executor relayHttpExecutor) {
        this.relayHttpExecutor = relayHttpExecutor;
        return this;
    }

    public JugglerDirectClientOptions setRelayConnectTimeout(Duration relayConnectTimeout) {
        this.relayConnectTimeout = relayConnectTimeout;
        return this;
    }

    public JugglerDirectClientOptions setRelayResponseTimeout(Duration relayResponseTimeout) {
        this.relayResponseTimeout = relayResponseTimeout;
        return this;
    }

    public JugglerDirectClientOptions setRelayCircuitBreakerFactory(CircuitBreakerFactory relayCircuitBreakerFactory) {
        this.relayCircuitBreakerFactory = relayCircuitBreakerFactory;
        return this;
    }
}
