package ru.yandex.juggler.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.juggler.future.StatusAware;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class EventStatus implements StatusAware {
    public int code;
    public String message;

    public EventStatus() {
    }

    public EventStatus(String message, int code) {
        this.code = code;
        this.message = message;
    }

    public EventStatus(int code) {
        this.code = code;
    }

    public EventStatus(Throwable exception) {
        this.code = HttpStatus.SC_500_INTERNAL_SERVER_ERROR;
        this.message = exception.getMessage();
    }

    @Override
    public boolean isOk() {
        return HttpStatus.is2xx(code);
    }
}
