package ru.yandex.juggler.dto;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableList;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetConfigResponse {
    public static class Relay {
        public String address;
        public int weight;

        public Relay() {
        }

        public Relay(String address, int weight) {
            this.address = address;
            this.weight = weight;
        }
    }

    public static class Target {
        public String name;
        public List<Relay> relays;
        @JsonIgnore
        public boolean isRegional;

        public Target() {
        }

        public Target(String name, List<Relay> relays, boolean isRegional) {
            this.name = name;
            this.relays = ImmutableList.copyOf(relays);
            this.isRegional = isRegional;
        }

        public Target(String name, List<Relay> relays) {
            this.name = name;
            this.relays = ImmutableList.copyOf(relays);
            this.isRegional = false;
        }
    }

    public List<Target> targets;
}
