package ru.yandex.juggler.dto;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerEvent {
    public final String host;
    public final String service;
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public final String instance;
    public final Status status;
    public final String description;
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public final List<String> tags;
    @JsonIgnore
    public final String projectId;

    /**
     * Unix seconds time when event was created, or zero if unknown
     */
    @JsonProperty(value = "open_time")
    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    public final double openTimeSeconds;

    public JugglerEvent(String host, String service, String instance, Status status, String description) {
        this(host, service, instance, status, description, List.of(), 0, "");
    }

    public JugglerEvent(String host, String service, String instance, Status status, String description, List<String> tags) {
        this(host, service, instance, status, description, tags, 0, "");
    }

    public JugglerEvent(String host, String service, String instance, Status status, String description, List<String> tags, double openTimeSeconds, String projectId) {
        this.description = description;
        this.host = host;
        this.service = service;
        this.instance = instance;
        this.status = status;
        this.tags = tags;
        this.openTimeSeconds = openTimeSeconds;
        this.projectId = projectId;
    }

    public enum Status {
        INFO,
        OK,
        WARN,
        CRIT,
        ;
    }
}
