package ru.yandex.juggler.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class BadGatewayException extends JugglerRuntimeException {
    public BadGatewayException(String msg) {
        super(msg, HttpStatus.SC_502_BAD_GATEWAY);
    }

    public BadGatewayException(String msg, Throwable cause) {
        super(msg, cause, HttpStatus.SC_502_BAD_GATEWAY);
    }
}
