package ru.yandex.juggler.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.EventStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerRuntimeException extends RuntimeException {
    private final int code;

    public JugglerRuntimeException(String msg, int code) {
        super(msg);
        this.code = code;
    }

    public JugglerRuntimeException(String msg, Throwable cause, int code) {
        super(msg, cause);
        this.code = code;
    }

    public EventStatus toEventStatus() {
        EventStatus status = new EventStatus();
        status.code = code;
        status.message = getClass().getSimpleName() + ": " + getMessage();
        return status;
    }
}
