package ru.yandex.juggler.relay;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.http.HttpClientMetrics;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class HttpRelayMetrics {
    public final HttpClientMetrics.Endpoint eventsMetrics;
    public final Rate circuitBreakerDisallows;

    public HttpRelayMetrics(MetricRegistry registry) {
        var httpMetrics = new HttpClientMetrics("juggler-relay-client", registry);
        this.eventsMetrics = httpMetrics.endpoint("/events");
        this.circuitBreakerDisallows = registry.rate("circuitBreaker.disallowRate");
    }
}
