package ru.yandex.juggler.relay;

import java.net.http.HttpClient;
import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerHttpRelayFactory implements JugglerRelayFactory {
    private final HttpClient httpClient;
    private final MetricRegistry registry;
    private final Duration timeout;
    private final CircuitBreakerFactory circuitBreakerFactory;

    public JugglerHttpRelayFactory(
            HttpClient httpClient,
            MetricRegistry registry,
            Duration timeout,
            CircuitBreakerFactory circuitBreakerFactory)
    {
        this.httpClient = httpClient;
        this.registry = registry;
        this.timeout = timeout;
        this.circuitBreakerFactory = circuitBreakerFactory;
    }

    @Override
    public JugglerRelay makeRelay(String targetName, String address) {
        var subRegistry = registry.subRegistry("jugglerTarget", targetName);
        return new JugglerHttpRelay(address, httpClient, subRegistry, timeout, circuitBreakerFactory.makeCircuitBreaker());
    }
}
