package ru.yandex.juggler.resolver;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.juggler.dto.GetConfigResponse;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class FixedProxyResolverStub implements ProxyResolver {
    private FixedProxyResolverStub(Builder builder, ProxyResolveObserver observer) {
        observer.updateTargetConfig(ImmutableList.copyOf(builder.targets));
    }

    public static TargetBuilder addTarget(String name) {
        var builder = new Builder();
        return new TargetBuilder(builder, name);
    }

    public static class Builder {
        private final List<GetConfigResponse.Target> targets = new ArrayList<>(3);

        private Builder addTarget(GetConfigResponse.Target target) {
            targets.add(target);
            return this;
        }
    }

    public static class TargetBuilder {
        private final Builder builder;
        private final String name;
        private final List<GetConfigResponse.Relay> relays = new ArrayList<>(3);

        private TargetBuilder(Builder builder, String name) {
            this.builder = builder;
            this.name = name;
        }

        public TargetBuilder addRelay(String address) {
            return addRelay(address, 1);
        }

        public TargetBuilder addRelay(String address, int weight) {
            var relay = new GetConfigResponse.Relay(address, weight);
            relays.add(relay);
            return this;
        }

        private GetConfigResponse.Target completeTarget() {
            return new GetConfigResponse.Target(name, relays);
        }

        public TargetBuilder addTarget(String newName) {
            builder.addTarget(completeTarget());
            return new TargetBuilder(builder, newName);
        }

        public ProxyResolver build(ProxyResolveObserver observer) {
            return new FixedProxyResolverStub(builder.addTarget(completeTarget()), observer);
        }
    }
}
