package ru.yandex.juggler.resolver;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.GetConfigResponse;
import ru.yandex.solomon.config.protobuf.alert.JugglerChannelConfig;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class FixedTargetsResolver implements ProxyResolver {
    public FixedTargetsResolver(JugglerChannelConfig.JugglerBackendsConfig backendsConfig, ProxyResolveObserver observer) {
        List<GetConfigResponse.Target> targets = new ArrayList<>();
        for (var target : backendsConfig.getTargetsList()) {
            List<GetConfigResponse.Relay> relays = new ArrayList<>();
            for (String relay : target.getRelaysList()) {
                relays.add(new GetConfigResponse.Relay(relay, 1));
            }
            targets.add(new GetConfigResponse.Target(target.getTargetName(), relays));
        }
        observer.updateTargetConfig(targets);
    }
}
