package ru.yandex.juggler.resolver;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.GetConfigResponse;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SinglePushWrapperResolver implements ProxyResolver {
    public SinglePushWrapperResolver(String address, ProxyResolveObserver observer) {
        var relay = new GetConfigResponse.Relay(address, 1);
        var config = List.of(new GetConfigResponse.Target(address, List.of(relay)));
        observer.updateTargetConfig(config);
    }
}
