package ru.yandex.juggler.target;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class JugglerTargetOptions {
    String applicationName = "solomon";

    Executor flusherExecutor = null;
    ScheduledExecutorService timer = null;
    int queueCapacity = 1000;
    int batchSizeHint = 100;

    long flushIntervalMillis = 200;
    int maxSendRetries = 2;
    long retryDelayMillis = 500;

    public JugglerTargetOptions() {
    }

    public JugglerTargetOptions setFlusherExecutor(Executor flusherExecutor) {
        this.flusherExecutor = flusherExecutor;
        return this;
    }

    public JugglerTargetOptions setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public JugglerTargetOptions setBatchSizeHint(int batchSizeHint) {
        this.batchSizeHint = batchSizeHint;
        return this;
    }

    public JugglerTargetOptions setFlushIntervalMillis(long flushIntervalMillis) {
        this.flushIntervalMillis = flushIntervalMillis;
        return this;
    }

    public JugglerTargetOptions setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public JugglerTargetOptions setMaxSendRetries(int maxSendRetries) {
        this.maxSendRetries = maxSendRetries;
        return this;
    }

    public JugglerTargetOptions setRetryDelayMillis(long retryDelayMillis) {
        this.retryDelayMillis = retryDelayMillis;
        return this;
    }

    public JugglerTargetOptions setTimer(ScheduledExecutorService timer) {
        this.timer = timer;
        return this;
    }
}
