package ru.yandex.juggler.target;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.juggler.dto.EventStatus;
import ru.yandex.juggler.dto.JugglerEvent;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SendOperation {
    private final JugglerEvent event;
    private final CompletableFuture<EventStatus> response;

    public SendOperation(JugglerEvent event, CompletableFuture<EventStatus> response) {
        this.event = event;
        this.response = response;
    }

    public void complete(EventStatus result) {
        this.response.complete(result);
    }

    public JugglerEvent getEvent() {
        return event;
    }
}
